--********************************************************************************
--If you should have any comments, suggestions or improvements to these samples, 
--we welcome you to contact us at SampleCode@melissadata.com also please visit our 
--developers bulletin board at forum.melissadata.com.
--********************************************************************************


SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

DROP PROCEDURE sp_VerifyAddress
GO

CREATE PROCEDURE sp_VerifyAddress AS

-- DECLARE variables.
DECLARE @DataPath  char(100)
DECLARE @License char(20)
DECLARE @intObject int
DECLARE @intResult int
DECLARE @strRetval char(100)  
DECLARE @intRetval int
DECLARE @ELotOrder char(6)
DECLARE @ELotNumber char(10)
DECLARE @RecCnt float
DECLARE @Company char(40)
DECLARE @Address char(32)
DECLARE @Suite char(10)
DECLARE @City char(28)
DECLARE @State char(2)
DECLARE @Zip char(5)
DECLARE @Plus4 char(4)
DECLARE @CarrierRoute char(4)
DECLARE @DeliveryPointCode char(2)
DECLARE @DeliveryPointCheckDigit char(1)
DECLARE @CountyFips char(5)
DECLARE @MSA char(5)
DECLARE @Dash char(1)
DECLARE @SuiteStatus char(1)
DECLARE @initError char(100)
DECLARE @CountyName char(25)
DECLARE @DPVFootnotes char(6)
DECLARE @SuiteLinkReturnCode char(5)
DECLARE @Results char(25)
DECLARE @ResultsDesc char(250)


-- DECLARE a cursor from table name LIST
DECLARE AddCursor cursor for select company, address, city, state, zip from LIST

-- ********************** DATA FILES  *****************************
--  Set Path to Data Files and License String Here
--  The Data Files Directory must contain the following files: 
--  mdAddr.dat, mdAddr.lic, mdAddr.nat, and mdAddr.str.
-- ****************************************************************
SET  @DataPath = 'C:\Program Files\Melissa Data\DQT\Data'

-- ********************** LICENSE STRINGS *************************
--       To unlock the full functionality of Address Object,      
--   please call a sales representative at 1-800-MELISSA ext. 3    
--           (1-800-635-4772 x3) for a license string.            
--       Without a valid license string, Address Object will      
--                  only verify Nevada addresses.                 
--   SetLicenseString also checks for a valid license in the 
--   MDADDR_LICENSE environment variable. 
--   This allows you to modify the license without recompilation.
-- **************************************************************** 
SET  @License = 'DEMO'


SET  @RecCnt = 0	-- Record count
SET  nocount on		

-- Create Address Object.
EXEC @intResult = sp_OACreate 'AddressObject.AddressCheck', @intObject OUT
IF @intResult <> 0
BEGIN
    RAISERROR ('Object Creation Error', 1, 2)
    RETURN
END  
EXEC @intResult = sp_OAMethod @intObject, SetLicenseString,  @strRetval OUT, @License


-- Set Path To US Data Files
EXEC sp_OASetProperty @intObject, PathToUSFiles, @DataPath

-- DPV and LACSLink, CASS required add-ons for highest level of validation. Should be used by non-demo users.
-- EXEC @intResult = sp_OASetProperty @intObject, PathToDPVDataFiles, @DataPath
-- EXEC @intResult = sp_OASetProperty @intObject, PathToLACSLinkDataFiles, @DataPath

-- Suite Link 
-- EXEC @intResult = sp_OASetProperty @intObject, PathToSuiteLinkDataFiles, @DataPath

-- RDBI - Delivery Indicator Add-on (Residence or Business) 
-- EXEC @intResult = sp_OASetProperty @intObject, PathToRBDIFiles @DataPath

-- Canadian - Canadian Address Validation Add-on
-- EXEC @intResult = sp_OASetProperty @intObject, PathToCanadaFiles @DataPath

-- AddressPlus Add-on (appends residential suites)
-- EXEC @intResult = sp_OASetProperty @intObject, PathToSuiteFinderDataFiles, @DataPath

--Get Build Number
EXEC @intResult = sp_OAMethod @intObject, GetBuildNumber,  @strRetval OUT
PRINT 'Build Number=' + @strRetval

-- Initialize data file - use the default
EXEC @intResult = sp_OAMethod @intObject, InitializeDataFiles, @intRetval OUT
IF @intResult <> 0 OR @intRetval <> 0	-- Intialization failed
BEGIN
	EXEC @intResult = sp_OAMethod @intObject, GetInitializeErrorString, @initError OUT
	PRINT 'Data File Initialization Error=' + @initError
	RAISERROR ('Initialize Error',  1, 2) 
    	RETURN
END  

--Get Database Date
EXEC @intResult = sp_OAMethod @intObject, GetUSDatabaseDate,  @strRetval OUT
PRINT 'Database Date=' + @strRetval

--Get Expiration Date
EXEC @intResult = sp_OAMethod @intObject, GetUSExpirationDate,  @strRetval OUT
PRINT 'Database Expiration Date=' + @strRetval

OPEN AddCursor

-- Perform the first fetch.
FETCH NEXT FROM AddCursor INTO @Company, @Address, @City, @State, @Zip

-- Check FETCH_STATUS to see if there are any more rows to fetch.
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @RecCnt = @RecCnt + 1	

	--Clear and Set Properities the Address
	EXEC @intResult = sp_OAMethod @intObject, ClearProperties
	EXEC @intResult =sp_OASetProperty @intObject, company, @company
	EXEC @intResult =sp_OASetProperty @intObject, Address, @Address
	EXEC @intResult =sp_OASetProperty @intObject, City, @City
	EXEC @intResult =sp_OASetProperty @intObject, State, @State
	EXEC @intResult =sp_OASetProperty @intObject, Zip, @Zip
	-- Set the Last Name Input Property for SuiteFinder Add-on
	 EXEC @intResult =sp_OASetProperty @intObject, LastName, 'Last Name Here'

	-- Call the Verify Address method
	EXEC @intResult = sp_OAMethod @intObject, VerifyAddress, @intRetval OUT
	IF @intResult <> 0
	BEGIN
		PRINT 'Error=' + str(@intResult)
		RAISERROR ('VerifyAddress Method Error',  1, 2) 
		RETURN
	END  

	-- Use this statement to do special processing if the address was validated or not
	--IF @intRetval <> 1
		--Problem with address found
	--	SET @Dash = ' ' -- Don't show a dash between the ZIP Code and Plus4
	--ELSE
		--Address was verified
	--	SET @Dash = '-' -- Show a dash between the ZIP Code and Plus4

	-- Retrieve information from the COM object
	EXEC @intResult =sp_OAGetProperty @intObject, Address, @Address OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Suite, @Suite OUT
	EXEC @intResult =sp_OAGetProperty @intObject, City, @City OUT
	EXEC @intResult =sp_OAGetProperty @intObject, State, @State OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Zip, @Zip OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Plus4, @Plus4 OUT
	EXEC @intResult =sp_OAGetProperty @intObject, CarrierRoute, @CarrierRoute OUT
	EXEC @intResult =sp_OAGetProperty @intObject, DeliveryPointCode, @DeliveryPointCode OUT
	EXEC @intResult =sp_OAGetProperty @intObject, DeliveryPointCheckDigit, @DeliveryPointCheckDigit OUT
	EXEC @intResult =sp_OAGetProperty @intObject, ELotOrder, @ELotOrder OUT
	EXEC @intResult =sp_OAGetProperty @intObject, ELotNumber, @ELotNumber OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Results, @Results OUT
	EXEC @intResult =sp_OAGetProperty @intObject, CountyFips, @CountyFips OUT
	EXEC @intResult =sp_OAGetProperty @intObject, CountyName, @CountyName OUT
	EXEC @intResult =sp_OAGetProperty @intObject, DPVFootnotes, @DPVFootnotes OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Suite, @Suite OUT
	EXEC @intResult =sp_OAGetProperty @intObject, Msa, @MSA OUT
set @ResultsDesc = ''
   IF (@Results like '%AS01%') Or (@Results like '%AS02%') 
     -- Address was verified
     BEGIN
       IF @Results like '%AS01%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Full Address Matched to Postal Database and is deliverable.'
		 END
	   IF @Results like '%AS02%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Address matched to USPS database but a suite was missing or invalid.'
		 END
     END

    -- Display additional level of verification/comments
	   IF @Results like '%AS09%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Foreign Postal Code Detected.'
		 END			   
	   IF @Results like '%AS10%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Address Matched to CMRA.'
		 END			
	   IF @Results like '%AS13%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Address has been Updated by LACSLink.'
		 END
       IF @Results like '%AS14%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Suite Appended by SuiteLink.'
		 END
       IF @Results like '%AS15%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Suite Appended by SuiteFinder.'
		 END
       IF @Results like '%AS16%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Address is vacant.'
		 END
       IF @Results like '%AS17%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Alternate delivery.'
		 END
       IF @Results like '%AS18%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Artificially created adresses detected, DPV processing terminated at this point.'
		 END
	   IF @Results like '%AS20%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Address Deliverable by USPS only.'
		 END
	   IF @Results like '%AS21%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Alternate Address Suggestion Found.'
		 END
       IF @Results like '%AS22%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'No Alternate Address Suggestion Found.'
		 END
       IF @Results like '%AS23%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Extraneous information found.'
		 END
     
   IF @Results like '%AE%'
     -- there was an error verifying the record
     BEGIN
       IF @Results like '%AE01%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Zip Code Error.'
		 END
       IF @Results like '%AE02%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Unknown Street Error.'
		 END
       IF @Results like '%AE03%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Component Mismatch Error.'
		 END
       IF @Results like '%AE04%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Non-Deliverable Address Error.'
		 END
       IF @Results like '%AE05%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Multiple Match Error.'
		 END
       IF @Results like '%AE06%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Early Warning System Error.'
		 END
       IF @Results like '%AE07%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Missing Minimum Address Input.'
		 END
       IF @Results like '%AE08%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Suite Range Invalid Error.'
		 END
       IF @Results like '%AE09%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Suite Range Missing Error.'
		 END
       IF @Results like '%AE10%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Primary Range Invalid Error.'
		 END
       IF @Results like '%AE11%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Primary Range Missing Error.'
		 END
       IF @Results like '%AE12%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'PO, HC, or RR Box Number Invalid.'
		 END
       IF @Results like '%AE13%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'PO, HC, or RR Box Number Missing.'
		 END
       IF @Results like '%AE14%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'CMRA Secondary Missing Error.'
		 END

       -- program can not attempt address lookup
       IF @Results like '%AE15%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Demo Mode Limitation, valid license required.'
		 END
       IF @Results like '%AE16%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Expired Database, Please Update.'
		 END
		 
	   IF @Results like '%AE17%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Unnecessary Suite Error.'
		 END
       IF @Results like '%AE19%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Max time for FindSuggestion exceeded.'
		 END
       IF @Results like '%AE20%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'FindSuggestion cannot be used.'
		 END 
     END

-- a change was made to the address
	   IF @Results like '%AC01%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'ZIP Code Change.'
		 END			   
	   IF @Results like '%AC02%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'State Change.'
		 END			
	   IF @Results like '%AC03%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'City Change.'
		 END
       IF @Results like '%AC04%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Base/Alternate Change.'
		 END
       IF @Results like '%AC05%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Alias Name Change.'
		 END
       IF @Results like '%AC06%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Address1/Address2 Swap.'
		 END
       IF @Results like '%AC07%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Address1/Company Swap.'
		 END
       IF @Results like '%AC08%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Plus4 Change.'
		 END
	   IF @Results like '%AC09%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Urbanization Change.'
		 END
	   IF @Results like '%AC10%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Street Name Change.'
		 END
	   IF @Results like '%AC11%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Street Suffix Change.'
		 END
	   IF @Results like '%AC12%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Street Directional Change.'
		 END
	   IF @Results like '%AC13%'
         BEGIN
            set @ResultsDesc = rtrim(@ResultsDesc) + 'Suite Name Change.'
		 END

	-- Update the table with new information
	UPDATE LIST SET Address_Output = rtrim(@Address), 
                    City=@City, 
                    State = @State, 
                    Zip=@Zip,
                    Plus4=@Plus4, 
					CountyFips = @CountyFips, 
                    CountyName = @CountyName, 
                    MSA = @MSA,
					CRRT=@CarrierRoute, 
                    DPC = @DeliveryPointCode + @DeliveryPointCheckDigit, 
					DPVFootnotes = @DPVFootnotes, 
                    Suite = @Suite,
					Results = @Results, 
                    ResultsDesc = @ResultsDesc,
                    ELotOrder = @ELotOrder,
					ELotNumber = @ELotNumber where current of AddCursor

	-- Get next record	
	FETCH NEXT FROM AddCursor into @Company, @Address, @City, @State, @Zip
END

--Close and de-allocate cursor
CLOSE AddCursor
DEALLOCATE AddCursor

-- Destroy Address Object.
EXEC @intResult = sp_OADestroy @intObject
IF @intResult <> 0
BEGIN
    RAISERROR ('Destroy Object Error', 1, 2)
    RETURN
END



GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

